# optprloc.mod   QQR2-AN-30-30
# AMPL coding: S. Leyffer, January 1999.
#
# Source: Optimal positioning of a new product in a multiattribute 
#         space: market of M existing products, set of N consumers 
#         in a multiattribute space of dimension K. See, e.g.
#         M. Duran & I.E. Grossmann,
#        "An outer approximation algorithm for a class of mixed integer 
#         nonlinear programs", Mathematical Programming 36, pp. 307-339, 1986.
#
# Number of variables:   30 (25 binary variables)  
# Number of constraints: 30 (1 redundant linear constraint lin4)
# Objective quadratic
# Quadratic constraints

param k :=  5;            # number of attributes
param m := 10;            # number of products
param n := 25;            # number of consumers
param h := 1000.0;         

set K := 1..k;
set M := 1..m;
set N := 1..n;
set NxK within (N cross K);
set MxK within (M cross K);

param Z {NxK};            # ideal points Z(n,k)
param W {NxK};            # attribute weights W(n,k)
param D {MxK};            # existing products D(m,k)
param R {N};              # min ( sum_k W(n,k) * ( DEL(m,k) - Z(n,k) )**2

param l {K} default 0;    # lower/upper bounds on x[i]
param u {K} default 4.5;

var x {i in K} >= l[i], <= u[i];
var y {N}      >= 0,    <= 1,   binary;

minimize profit:
  - y[1] - 0.2*y[2] - y[3] - 0.2*y[4] - 0.9*y[5] - 0.9*y[6] - 0.1*y[7] 
  - 0.8*y[8] - y[9] - 0.4*y[10] - y[11] - 0.3*y[12] - 0.1*y[13] 
  - 0.3*y[14] - 0.5*y[15] - 0.9*y[16] - 0.8*y[17] - 0.1*y[18] - 0.9*y[19] 
  - y[20] - y[21] - y[22] - 0.2*y[23] - 0.7*y[24] - 0.7*y[25] - 0.9*x[2] 
  - 0.5*x[3]  + x[5] + 0.6*x[1]^2 + 0.1*x[4]^2;

s.t.
   ellipsoid {i in N}:
         sum {j in K} ( W[i,j]*( x[j] - Z[i,j] )^2 )
         - (1 - y[i])*h <= R[i];
   lin1: x[1] - x[2] + x[3] + x[4] + x[5] <= 10;
   lin2: 0.6*x[1] - 0.9*x[2] - 0.5*x[3] + 0.1*x[4] + x[5] <= -0.64;
   lin3: x[1] - x[2] + x[3] - x[4] + x[5] >= 0.69;
   lin4: 0.157*x[1] + 0.05*x[2] <= 1.5;
   lin5: 0.25*x[2] + 1.05*x[4] - 0.3*x[5] >= 4.5;

data;
param: u := 
            2   8.0
            3   9.0
            4   5.0
            5  10.0;

param: l := 
            1   2.0
            3   3.0
            5   4.0;

param: R := 
            1   77.83985
            2   175.9710
            3   201.8226
            4   143.9533
            5   154.3895
            6   433.3177
            7   109.0764
            8   41.59592
            9   144.0623
            10  99.83416
            11  149.1791
            12  123.8074
            13  27.22197
            14  89.92683
            15  293.0766
            16  174.3170
            17  125.1028
            18  222.8417
            19  50.48593
            20  361.1973
            21  40.32642
            22  161.8518
            23  66.85827
            24  340.5807
            25  407.5200;

param:  NxK:     Z,     W :=
        1 1     2.26   9.57
        1 2     5.15   2.74
        1 3     4.03   9.75
        1 4     1.74   3.96
        1 5     4.74   8.67
        2 1     5.51   8.38
        2 2     9.01   3.93
        2 3     3.84   5.18
        2 4     1.47   5.20
        2 5     9.92   7.82
        3 1     4.06   9.81
        3 2     1.80   0.04
        3 3     0.71   4.21
        3 4     9.09   7.38
        3 5     8.13   4.11
        4 1     6.30   7.41
        4 2     0.11   6.08
        4 3     4.08   5.46
        4 4     7.29   4.86
        4 5     4.24   1.48
        5 1     2.81   9.96
        5 2     1.65   9.13
        5 3     8.08   2.95
        5 4     3.99   8.25
        5 5     3.51   3.58
        6 1     4.29   9.39
        6 2     9.49   4.27
        6 3     2.24   5.09
        6 4     9.78   1.81
        6 5     1.52   7.58
        7 1     9.76   1.88
        7 2     3.64   7.20
        7 3     6.62   6.65
        7 4     3.66   1.74
        7 5     9.08   2.86
        8 1     1.37   4.01
        8 2     6.99   2.67
        8 3     7.19   4.86
        8 4     3.03   2.55
        8 5     3.39   6.91
        9 1     8.89   4.18
        9 2     8.29   1.92
        9 3     6.05   2.60
        9 4     7.48   7.15
        9 5     4.09   2.86
        10 1    7.42   7.81
        10 2    4.60   2.14
        10 3    0.30   9.63
        10 4    0.97   7.61
        10 5    8.77   9.17
        11 1    1.54   8.96
        11 2    7.06   3.47
        11 3    0.01   5.49
        11 4    1.23   4.73
        11 5    3.11   9.43
        12 1    7.74   9.94
        12 2    4.40   1.63
        12 3    7.93   1.23
        12 4    5.95   4.33
        12 5    4.88   7.08
        13 1    9.94   0.31
        13 2    5.21   5.00
        13 3    8.58   0.16
        13 4    0.13   2.52
        13 5    4.57   3.08
        14 1    9.54   6.02
        14 2    1.57   0.92
        14 3    9.66   7.47
        14 4    5.24   9.74
        14 5    7.90   1.76
        15 1    7.46   5.06
        15 2    8.81   4.52
        15 3    1.67   1.89
        15 4    6.47   1.22
        15 5    1.81   9.05
        16 1    0.56   5.92
        16 2    8.10   2.56
        16 3    0.19   7.74
        16 4    6.11   6.96
        16 5    6.40   5.18
        17 1    3.86   6.45
        17 2    6.68   1.52
        17 3    6.42   0.06
        17 4    7.29   5.34
        17 5    4.66   8.47
        18 1    2.98   1.04
        18 2    2.98   1.36
        18 3    3.03   5.99
        18 4    0.02   8.10
        18 5    0.67   5.22
        19 1    3.61   1.40
        19 2    7.62   1.35
        19 3    1.79   0.59
        19 4    7.80   8.58
        19 5    9.81   1.21
        20 1    5.68   6.68
        20 2    4.24   9.48
        20 3    4.17   1.60
        20 4    6.75   6.74
        20 5    1.08   8.92
        21 1    5.48   1.95
        21 2    3.74   0.46
        21 3    3.34   2.90
        21 4    6.22   1.79
        21 5    7.94   0.99
        22 1    8.13   5.18
        22 2    8.72   5.10
        22 3    3.93   8.81
        22 4    8.80   3.27
        22 5    8.56   9.63
        23 1    1.37   1.47
        23 2    0.54   5.71
        23 3    1.55   6.95
        23 4    5.56   1.42
        23 5    5.85   3.49
        24 1    8.79   5.40
        24 2    5.04   3.12
        24 3    4.83   5.37
        24 4    6.94   6.10
        24 5    0.38   3.71
        25 1    2.66   6.32
        25 2    4.19   0.81
        25 3    6.49   6.12
        25 4    8.04   6.73
        25 5    1.66   7.93;

param: MxK:    D   :=
       1 1    0.62
       1 2    5.06
       1 3    7.82
       1 4    0.22
       1 5    4.42
       2 1    5.21
       2 2    2.66
       2 3    9.54
       2 4    5.03
       2 5    8.01
       3 1    5.27
       3 2    7.72
       3 3    7.97
       3 4    3.31
       3 5    6.56
       4 1    1.02
       4 2    8.89
       4 3    8.77
       4 4    3.10
       4 5    6.66
       5 1    1.26
       5 2    6.80
       5 3    2.30
       5 4    1.75
       5 5    6.65
       6 1    3.74
       6 2    9.06
       6 3    9.80
       6 4    3.01
       6 5    9.52
       7 1    4.64
       7 2    7.99
       7 3    6.69
       7 4    5.88
       7 5    8.23
       8 1    8.35
       8 2    3.79
       8 3    1.19
       8 4    1.96
       8 5    5.88
       9 1    6.44
       9 2    0.17
       9 3    9.93
       9 4    6.80
       9 5    9.75
       10 1   6.49
       10 2   1.92
       10 3   0.05
       10 4   4.89
       10 5   6.43;
